/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.interfaces.wire;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class RedstoneConductor {
    @Nullable
    private Network network;
    private boolean propagate = true;
    private int input;

    public abstract int getPower();

    public abstract void visit(Visitor var1);

    public abstract void onPropagated(int var1);

    public abstract void scheduleSequentialUpdate();

    public void doSequentialUpdate() {
        if (this.network == null) {
            Network.build(this);
            this.propagate = true;
        }
        if (this.network != null && this.propagate) {
            this.network.propagate();
        }
    }

    public void setInput(int newInput) {
        int power = this.getPower();
        if (newInput != this.input && (this.input == power && newInput < power || newInput > power)) {
            this.propagate = true;
            this.scheduleSequentialUpdate();
        }
        this.input = newInput;
    }

    public void setInputOnLoad(int newInput) {
        this.input = newInput;
    }

    public void invalidateNetwork() {
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    private static final class Network {
        private final Set<RedstoneConductor> conductors;

        private Network(Set<RedstoneConductor> conductors) {
            this.conductors = conductors;
        }

        public void propagate() {
            int power = 0;
            for (RedstoneConductor conductor : this.conductors) {
                power = Math.max(power, conductor.input);
            }
            for (RedstoneConductor conductor : this.conductors) {
                conductor.propagate = false;
                conductor.onPropagated(power);
            }
        }

        public void invalidate() {
            for (RedstoneConductor conductor : this.conductors) {
                conductor.network = null;
                conductor.propagate = true;
                conductor.scheduleSequentialUpdate();
            }
        }

        public static void build(RedstoneConductor origin) {
            HashSet<RedstoneConductor> conductors = new HashSet<RedstoneConductor>();
            ArrayDeque<RedstoneConductor> queue = new ArrayDeque<RedstoneConductor>();
            Network network = new Network(conductors);
            queue.add(origin);
            Visitor visitor = conductor -> {
                if (conductor != null) {
                    queue.add(conductor);
                }
            };
            while (!queue.isEmpty()) {
                RedstoneConductor conductor2 = (RedstoneConductor)queue.pop();
                if (!conductors.add(conductor2)) continue;
                conductor2.network = network;
                conductor2.visit(visitor);
            }
        }
    }

    public static interface Visitor {
        public void accept(RedstoneConductor var1);
    }
}

